/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connmgr;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.connmgr.ContextId;
import com.ibm.hwmca.fw.connmgr.InvalidPasswordException;
import com.ibm.hwmca.fw.task.UserContext;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public abstract class Authenticator {
    protected DataInputStream input;
    protected DataOutputStream output;
    protected Socket socket;

    public Authenticator(Socket socket) throws IOException {
        this.socket = socket;
    }

    public abstract String getUserName();

    public abstract UserContext getContext();

    public abstract boolean verifyContext(ContextId var1) throws HException, IOException;

    public abstract boolean verifyUseridAndPassword(String var1, byte[] var2) throws HException, IOException, InvalidPasswordException;

    public abstract boolean authenticateClient(GateKeeper var1, ContextKeeper var2) throws HException, IOException, InvalidPasswordException;

    public static void dumpBytes(byte[] bytes) {
        System.out.println(Authenticator.bytes2String(bytes));
    }

    public static String bytes2String(byte[] bytes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (bytes != null) {
            int i = 0;
            while (i < bytes.length) {
                buffer.append(" " + bytes[i]);
                ++i;
            }
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    protected void writeByteArray(byte[] bytes) throws IOException {
        int length = bytes.length;
        this.output.writeInt(length);
        this.output.write(bytes);
    }

    protected byte[] readByteArray() throws IOException {
        byte[] array = null;
        try {
            int length = this.input.readInt();
            array = new byte[length];
            this.input.readFully(array);
        }
        catch (OutOfMemoryError e) {
            throw new IOException("Failed to allocate the requested byte array.  There is probably a mismatch in authentication protocols. ");
        }
        return array;
    }

    public static interface ContextKeeper {
        public UserContext getContext(ContextId var1) throws HException;
    }

    public static interface GateKeeper {
        public byte[] getPassword(String var1) throws HException;
    }
}

